import { useState } from "react"
import Rating from "../Rating"

export default function Testimonial1({ data }) {
    const { section_title, section_subtitle, testimonial_list } = data
    const [activeIndex, setActiveIndex] = useState(1)
    return (
        <div className="container">
            {(section_title || section_subtitle) && (
                <>
                    <div className="cs_section_heading cs_style_1 text-center">
                        {section_title && (
                            <>
                                <h2
                                    className="cs_section_title cs_fs_72 m-0"
                                    dangerouslySetInnerHTML={{
                                        __html: section_title
                                    }}
                                />
                            </>
                        )}
                        {section_subtitle && (
                            <>
                                <div className="cs_height_5" />
                                <h3
                                    className="cs_section_subtitle text-uppercase cs_accent_color cs_semibold m-0 cs_accent_color cs_fs_32"
                                    dangerouslySetInnerHTML={{
                                        __html: section_subtitle
                                    }}
                                />
                            </>
                        )}
                    </div>
                    <div className="cs_height_72 cs_height_lg_45" />
                </>
            )}

            <div className="cs_tabs cs_style1">
                <ul className="cs_tab_links">
                    {testimonial_list?.map((item, index) => (
                        <li key={index} className={activeIndex === index ? "active" : ""}>
                            <div className="cs_tab_link_in" onClick={() => setActiveIndex(index)}>
                                <div className="cs_testimonial_1_avatar">
                                    {item.avatar_image_url && <img src={item.avatar_image_url} alt={item.avatar_name} />}
                                    <div className="cs_testimonial_1_avatar_right">
                                        {item.avatar_name && (
                                            <h3
                                                className="cs_fs_24 cs_semibold mb-0"
                                                dangerouslySetInnerHTML={{
                                                    __html: item.avatar_name
                                                }}
                                            />
                                        )}
                                        {item.avatar_designation && (
                                            <p
                                                className="cs_heading_color mb-0"
                                                dangerouslySetInnerHTML={{
                                                    __html: item.avatar_designation
                                                }}
                                            />
                                        )}
                                    </div>
                                </div>
                            </div>
                        </li>
                    ))}
                </ul>
                <div className="cs_tab_body">
                    {testimonial_list?.map((item, index) => (
                        <div className="cs_tab" style={{ display: "inline-block" }} key={index}>
                            {activeIndex === index && (
                                <div className="cs_testimonial cs_style_1">
                                    <svg
                                        width="50"
                                        height="38"
                                        className="cs_accent_color"
                                        viewBox="0 0 50 38"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M39.5541 13.8357C39.4534 12.689 39.5304 9.57182 42.3655 5.23719C42.5799 4.9101 42.541 4.46895 42.2747 4.18851C41.1188 2.97105 40.4032 2.20281 39.9013 1.66522C39.2413 0.956385 38.9399 0.633403 38.4989 0.212251C38.2045 -0.0665425 37.7589 -0.0713971 37.4613 0.201883C32.5198 4.73095 27.0312 14.0896 27.8254 25.5554C28.2908 32.2879 32.9531 37.1746 38.911 37.1746C45.0251 37.1746 49.9995 31.9359 49.9995 25.4959C49.9995 19.2832 45.37 14.1884 39.5541 13.8357ZM38.911 35.5288C33.7946 35.5288 29.7885 31.2842 29.3834 25.4364C28.4899 12.5411 35.7676 4.1644 37.9664 1.94648C38.1808 2.16907 38.4257 2.43099 38.7866 2.81833C39.2214 3.28441 39.8166 3.92247 40.7168 4.87397C37.2752 10.459 37.9245 14.4384 38.209 15.0089C38.3441 15.2798 38.621 15.4622 38.911 15.4622C44.1638 15.4622 48.437 19.9631 48.437 25.4959C48.437 31.0279 44.1638 35.5288 38.911 35.5288Z"
                                            fill="currentColor"
                                        />
                                        <path
                                            d="M11.8075 13.8355C11.7061 12.692 11.7808 9.57721 14.619 5.23699C14.8326 4.90989 14.7944 4.46874 14.5282 4.1883C13.3746 2.97323 12.6597 2.20581 12.1585 1.66822C11.4963 0.957825 11.1941 0.633938 10.7532 0.212046C10.4586 -0.0667479 10.0131 -0.0707801 9.71559 0.200854C4.77403 4.72993 -0.715346 14.087 0.0773101 25.5552C0.544263 32.2868 5.20731 37.1744 11.1651 37.1744C17.2793 37.1744 22.2537 31.9357 22.2537 25.4957C22.2537 19.2823 17.6242 14.1867 11.8075 13.8355ZM11.1651 35.5286C6.04965 35.5286 2.04114 31.284 1.63528 25.4354C0.744185 12.5369 8.02184 4.16337 10.2206 1.94627C10.4357 2.16886 10.6815 2.43243 11.0431 2.82059C11.4772 3.28667 12.0715 3.92391 12.9703 4.87377C9.52864 10.4596 10.1779 14.4381 10.4625 15.0079C10.5975 15.2787 10.8752 15.462 11.1651 15.462C16.418 15.462 20.6912 19.9629 20.6912 25.4957C20.6912 31.0277 16.418 35.5286 11.1651 35.5286Z"
                                            fill="currentColor"
                                        />
                                    </svg>
                                    <p
                                        dangerouslySetInnerHTML={{
                                            __html: item.testimonial_text
                                        }}
                                    />
                                    {item.review_number && (
                                        <Rating className="cs_rating cs_accent_color" ratingNumber={item.review_number} />
                                    )}
                                </div>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </div>
    )
}
